<?php

use App\Http\Controllers\Api\V1\LandingController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\SiteController;
use App\Http\Controllers\Auth\AuthBasicController;
use App\Http\Controllers\Auth\GoogleJwtController;
use App\Http\Controllers\Profile\ProfileController;

// use App\Http\Controllers\Api\Auth\GoogleJwtController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
| Semua endpoint API akan otomatis diprefix dengan "/api"
| Jadi "/header" akan jadi "/api/v1/header"
*/

// Contoh route user default (bisa dihapus kalau tidak dipakai)
Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

// Route untuk API versi 1
Route::prefix('v1')->group(function () {
    Route::get('/header', [LandingController::class, 'header']);
    // Route::get('/sections', [LandingController::class, 'sections']);
    // Route::get('/banners', [LandingController::class, 'banners']);
    Route::get('/footer', [LandingController::class, 'footer']);
    Route::get('/landing', [LandingController::class, 'landing']);
    Route::get('/course', [LandingController::class, 'course']);
    Route::get('/mentor', [LandingController::class, 'mentor']);
    Route::get('/alumni', [LandingController::class, 'alumni']);
});

// Route untuk autentikasi Google JWT
Route::post('/auth/google',  [GoogleJwtController::class, 'loginWithIdToken']);
Route::post('/auth/refresh', [GoogleJwtController::class, 'refresh'])->middleware('auth:api');
// Route login register lokal
Route::post('/auth/register',[AuthBasicController::class,'register']);
Route::post('/auth/login',[AuthBasicController::class,'login']);
//Reset Password
Route::post('/forgot-password', [AuthBasicController::class, 'sendResetLink']);
Route::post('/reset-password', [AuthBasicController::class, 'reset']);

Route::middleware('auth:api')->group(function(){
    //logout
    Route::post('/auth/logout',  [GoogleJwtController::class, 'logout'])->middleware('auth:api');

    //profile
    Route::get('/profile', [ProfileController::class, 'getProfile']);
    Route::post('/profile/change-email', [ProfileController::class, 'changeEmail']);
    Route::post('/profile/change-password', [ProfileController::class, 'changePassword']);
    Route::post('/profile/change-avatar', [ProfileController::class, 'changeAvatar']);
    Route::delete('/profile/delete-account', [ProfileController::class, 'deleteAccount']);
});
