<?php

namespace Database\Seeders;

use App\Models\Course;
use App\Models\Mentor;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class MentorSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
          for ($i = 1; $i <= 5; $i++) {
            $mentor = Mentor::create([
                'image'        => 'mentors/nerd.png',
                'name'         => 'Rafi Hafizhni Anggia, M.ds',
                'rating'       => 4.9,
                'total_review' => 10,
                'achievement'  => 'Juara 1 UI/UX Design nasional',
                'certification'=> 'Master UX by NNGroup',
                'deadline'     => null,
            ]);

            $courses = Course::inRandomOrder()->take(rand(1, 3))->pluck('id');

            $mentor->courses()->attach($courses);
        }
    }
}
