<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
    Schema::create('mentors', function (Blueprint $table) {
        $table->id();
        $table->string('image')->nullable();
        $table->string('name');
        $table->decimal('rating', 2, 1)->default(0);
        $table->integer('total_review')->default(0);
        $table->string('achievement')->nullable();
        $table->string('certification')->nullable();
        $table->date('deadline')->nullable();
        $table->timestamps();
    });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('mentors');
    }
};
