<?php

namespace App\Notifications;

use Illuminate\Notifications\Notification;
use Illuminate\Notifications\Messages\MailMessage;

class CustomResetPassword extends Notification
{
    public $token;

    public function __construct($token)
    {
        $this->token = $token;
    }

    public function via($notifiable)
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        // URL FRONTEND kamu (diatur di .env)
        $frontendUrl = config('app.frontend_url') . '/reset-password?token=' . $this->token . '&email=' . urlencode($notifiable->email);

        return (new MailMessage)
            ->subject('Reset Password Akun Anda')
            ->greeting('Halo, ' . ($notifiable->name ?? 'User'))
            ->line('Kami menerima permintaan untuk reset password akun Anda.')
            ->action('Atur Password Baru', $frontendUrl)
            ->line('Jika Anda tidak meminta reset password, abaikan email ini.');
    }
}
