<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Topic extends Model
{
    protected $fillable = ['name', 'category_id', 'icon'];

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function courses()
    {
        return $this->hasMany(Course::class);
    }

    public function mentors()
    {
    return $this->belongsToMany(Mentor::class, 'mentor_topic');
    }

}
