<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Mentor extends Model
{
    protected $fillable = [
        'image', 'name', 'rating', 'total_review',
        'achievement', 'certification', 'deadline'
    ];

    public function courses()
    {
        return $this->belongsToMany(Course::class, 'course_mentor');
    }

    public function topics()
    {
        return $this->courses()->with('topic')->get()->pluck('topic')->unique('id');
    }

}